local assets =
{
	Asset("ANIM", "anim/bottle.zip"),
    Asset("ATLAS", "images/inventoryimages/bottle.xml"),
	Asset("ANIM", "anim/bottle_water.zip"),
    Asset("ATLAS", "images/inventoryimages/bottle_water.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bottle")
    inst.AnimState:SetBuild("bottle")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "bottle"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bottle.xml"
    inst:AddComponent("selfstacker")
	inst:AddComponent("fillable")
	inst.components.fillable.filledprefab = "bottle_water"
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

local function bottle_waterfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bottle_water")
    inst.AnimState:SetBuild("bottle_water")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()
local function onusebush(inst)
    local owner = inst.components.inventoryitem.owner
	owner.components.inventory:GiveItem( SpawnPrefab("bottle"))
	for k = 1, 10 do
	owner.components.inventory:GiveItem( SpawnPrefab("water"))end
	inst:Remove()
	end
    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "bottle_water"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bottle_water.xml"
    inst:AddComponent("selfstacker")
	inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(onusebush)
	inst:AddComponent("equippable")
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab("bottle", fn, assets),
Prefab("bottle_water", bottle_waterfn, assets)